<?php
/**
 * Plugin Name: WebSamurai
 * Plugin URI: https://websamurai.io
 * Description: AI-powered features for WordPress
 * Version: 1.0.1
 * Author: Kiera Howe, Wiley Solutions
 * Author URI: https://wileysol.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: websamurai
 *
 * @package WebSamurai
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants.
define( 'WEBSAMURAI_VERSION', '1.0.0' );
define( 'WEBSAMURAI_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'WEBSAMURAI_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'WEBSAMURAI_PLUGIN_FILE', __FILE__ );

// Include required files.
require_once WEBSAMURAI_PLUGIN_DIR . 'inc/enqueue.php';
require_once WEBSAMURAI_PLUGIN_DIR . 'inc/class-websamurai-api-keys.php';
require_once WEBSAMURAI_PLUGIN_DIR . 'inc/class-websamurai-mcp-server.php';
require_once WEBSAMURAI_PLUGIN_DIR . 'inc/class-websamurai-admin-page.php';
require_once WEBSAMURAI_PLUGIN_DIR . 'inc/ajax-handler.php';
require_once WEBSAMURAI_PLUGIN_DIR . 'inc/oauth-handler.php';
require_once WEBSAMURAI_PLUGIN_DIR . 'inc/samurai-site.php';
require_once WEBSAMURAI_PLUGIN_DIR . 'inc/oauth-api.php';
require_once WEBSAMURAI_PLUGIN_DIR . 'inc/oauth-cron.php';
