/**
 * Frontend entry point
 */
import { createRoot } from 'react-dom/client';
import App from './App';
import './styles.less';

// Initialize the app when DOM is ready
document.addEventListener( 'DOMContentLoaded', () => {
	// Create a container div and append to body
	const container = document.createElement( 'div' );
	container.id = 'websamurai-frontend-root';
	document.body.appendChild( container );

	// Render the app
	const root = createRoot( container );
	root.render( <App /> );
} );
