/**
 * Admin entry point
 */
import { createRoot } from 'react-dom/client';
import App from './App';
import MediaGenerate from './components/MediaGenerate';
import './styles.less';

// Initialize the app when DOM is ready
document.addEventListener( 'DOMContentLoaded', () => {
	const container = document.getElementById( 'websamurai-admin-root' );
	if ( container ) {
		const root = createRoot( container );
		root.render( <App /> );
	}

	const mediaGrid = document.querySelector(".wp-admin.wp-core-ui.upload-php #wp-media-grid");
	if ( mediaGrid ) {
		console.log("Adding Generate AI Image button to Media Library toolbar");
		let button = document.createElement("button");
		button.className = "websamurai-generate-image-btn";
		button.innerText = "Generate AI Image";
		button.onclick = ( e ) => {
			e.preventDefault();
			e.stopPropagation();
			console.log( 'stop' );

			let modal = document.querySelector('#websamurai-ai-image-modal-trigger');
			if( ! modal ) {
				modal = document.createElement('div');
				modal.id = 'websamurai-ai-image-modal-trigger';
				modal.onclick = ( e ) => {
					if( e.target.id === 'websamurai-ai-image-modal-trigger' ) {
						modal.remove();
					}
				}
				document.body.appendChild(modal);
			}
			const root = createRoot( modal );
			root.render( <MediaGenerate/> );
		};
		
		if ( mediaGrid ) {
			mediaGrid.childNodes[1].after(button);
		}
	}
} );
