/**
 * Admin App Component
 */
import { useState, useEffect } from 'react';
import ApiKeyManager from './components/ApiKeyManager';
import OAuthConnect from './components/OAuthConnect';
import PromptInstructions from './components/PromptInstructions';
import MediaGenerate from './components/MediaGenerate';

const App = () => {
  const [activeTab, setActiveTab] = useState('oauth');
  const [isConnected, setIsConnected] = useState(false);

  useEffect(() => {
    checkConnectionStatus();
  }, []);

  const checkConnectionStatus = async () => {
    try {
      const response = await fetch(
        `${window.samurAiAdmin.apiUrl}/oauth/status`,
        {
          headers: {
            'X-WP-Nonce': window.samurAiAdmin.nonce,
          },
        }
      );

      const data = await response.json();
      setIsConnected(data.connected || false);
    } catch (err) {
      console.error('Error checking OAuth status:', err);
    }
  };

  return (
    <div className="websamurai-admin">
      <div className="websamurai-admin-header">
        <h2>Samur AI Settings</h2>
        <p>Configure authentication and manage API keys</p>
      </div>

      <div className="websamurai-tabs">
        <div className="tab-navigation">
          <button
            className={`tab-button ${activeTab === 'oauth' ? 'active' : ''}`}
            onClick={() => setActiveTab('oauth')}
          >
            OAuth Connection
          </button>
          <button
            className={`tab-button ${activeTab === 'api-keys' ? 'active' : ''}`}
            onClick={() => setActiveTab('api-keys')}
          >
            API Keys
          </button>
          {isConnected && (
            <button
              className={`tab-button ${activeTab === 'prompt-instructions' ? 'active' : ''}`}
              onClick={() => setActiveTab('prompt-instructions')}
            >
              Extra Prompt Instructions
            </button>
          )}
          {isConnected && (
            <button
              className={`tab-button ${activeTab === 'media-generate' ? 'active' : ''}`}
              onClick={() => setActiveTab('media-generate')}
            >
              Generate AI Image
            </button>
          )}
        </div>

        <div className="tab-content">
          {activeTab === 'oauth' && <OAuthConnect onConnectionChange={checkConnectionStatus} />}
          {activeTab === 'api-keys' && <ApiKeyManager />}
          {activeTab === 'prompt-instructions' && isConnected && <PromptInstructions />}
          {activeTab === 'media-generate' && isConnected && <MediaGenerate />}
        </div>
      </div>
    </div>
  );
};

export default App;
