<?php
/**
 * OAuth Cron Jobs
 *
 * Handles scheduled tasks for OAuth connection maintenance
 *
 * @package WebSamurai
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Schedule daily OAuth refresh cron job
 *
 * @return void
 */
function websamurai_schedule_oauth_refresh() {
	if ( ! wp_next_scheduled( 'websamurai_daily_oauth_refresh' ) ) {
		wp_schedule_event( time(), 'daily', 'websamurai_daily_oauth_refresh' );
	}
}
add_action( 'wp', 'websamurai_schedule_oauth_refresh' );

/**
 * Daily OAuth refresh callback
 *
 * @return void
 */
function websamurai_daily_oauth_refresh_callback() {
	$auth_key = get_option( 'websamurai_cp_auth_key' );

	// Only run if we have an auth key (connected).
	if ( empty( $auth_key ) ) {
		return;
	}

	// Perform user data refresh.
	$user_data = websamurai_perform_user_refresh();

	if ( is_wp_error( $user_data ) ) {
		return;
	}

	// Log success.

	// Sync SamuraiSite record.
	$site_result = websamurai_sync_samurai_site();
	// Note: websamurai_sync_samurai_site() already handles disconnection on create failure.
}
add_action( 'websamurai_daily_oauth_refresh', 'websamurai_daily_oauth_refresh_callback' );

/**
 * Clear scheduled cron on plugin deactivation
 *
 * @return void
 */
function websamurai_clear_oauth_cron() {
	$timestamp = wp_next_scheduled( 'websamurai_daily_oauth_refresh' );
	if ( $timestamp ) {
		wp_unschedule_event( $timestamp, 'websamurai_daily_oauth_refresh' );
	}
}
register_deactivation_hook( WEBSAMURAI_PLUGIN_FILE, 'websamurai_clear_oauth_cron' );
