<?php
/**
 * Admin Page for WebSamurai
 *
 * @package WebSamurai
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Admin Page Class
 */
class WebSamurai_Admin_Page {

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'admin_menu', array( $this, 'add_admin_menu' ) );
	}

	/**
	 * Add admin menu
	 *
	 * @return void
	 */
	public function add_admin_menu() {
		add_menu_page(
			__( 'WebSamurai', 'websamurai' ),
			__( 'WebSamurai', 'websamurai' ),
			'manage_options',
			'websamurai',
			array( $this, 'render_admin_page' ),
			'dashicons-admin-network',
			30
		);
	}

	/**
	 * Render admin page
	 *
	 * @return void
	 */
	public function render_admin_page() {
		?>
		<div class="wrap">
			<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
			<div id="websamurai-admin-root"></div>
		</div>
		<?php
	}
}

// Initialize Admin Page.
new WebSamurai_Admin_Page();
