# Samur AI MCP Server

This WordPress plugin includes an HTTP-based Model Context Protocol (MCP) server with a single echo tool.

## Features

- **HTTP Transport**: Stateless, no persistent connection required
- **JSON-RPC 2.0**: Standard protocol implementation
- **Single Echo Tool**: Echoes back any message sent to it
- **WordPress REST API**: Built on WordPress REST API infrastructure
- **API Key Authentication**: Secure access with generated API keys
- **Admin Interface**: Easy-to-use interface for managing API keys

## Getting Started

### 1. Generate an API Key

1. Log in to your WordPress admin panel
2. Navigate to **Samur AI** in the admin menu
3. Enter a name for your API key (e.g., "Production Server")
4. Click **Generate API Key**
5. **Important**: Copy the API key immediately - you won't be able to see it again!

### 2. API Endpoints

#### Main MCP Endpoint
```
POST /wp-json/websamurai/v1/mcp
```

#### API Key Management Endpoints
```
GET    /wp-json/websamurai/v1/api-keys        (List keys - Admin only)
POST   /wp-json/websamurai/v1/api-keys        (Generate key - Admin only)
DELETE /wp-json/websamurai/v1/api-keys/{id}   (Delete key - Admin only)
```

#### Server Info Endpoint
```
GET /wp-json/websamurai/v1/mcp/info
```

## Authentication

All MCP requests require authentication using an API key. You can provide the API key in two ways:

### Method 1: Using X-API-Key Header
```bash
curl -X POST https://your.website.com/wp-json/websamurai/v1/mcp \
  -H "Content-Type: application/json" \
  -H "X-API-Key: sk_your_api_key_here" \
  -d '{...}'
```

### Method 2: Using Authorization Bearer Token
```bash
curl -X POST https://your.website.com/wp-json/websamurai/v1/mcp \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer sk_your_api_key_here" \
  -d '{...}'
```

## Usage Examples

### 1. Initialize Connection

```bash
curl -X POST https://your.website.com/wp-json/websamurai/v1/mcp \
  -H "Content-Type: application/json" \
  -H "X-API-Key: sk_your_api_key_here" \
  -d '{
    "jsonrpc": "2.0",
    "id": 1,
    "method": "initialize",
    "params": {
      "protocolVersion": "2024-11-05",
      "clientInfo": {
        "name": "test-client",
        "version": "1.0.0"
      }
    }
  }'
```

**Response:**
```json
{
  "jsonrpc": "2.0",
  "id": 1,
  "result": {
    "protocolVersion": "2024-11-05",
    "capabilities": {
      "tools": {
        "listChanged": false
      }
    },
    "serverInfo": {
      "name": "websamurai-echo-server",
      "version": "1.0.0",
      "protocolVersion": "2024-11-05"
    }
  }
}
```

### 2. List Available Tools

```bash
curl -X POST https://your.website.com/wp-json/websamurai/v1/mcp \
  -H "Content-Type: application/json" \
  -H "X-API-Key: sk_your_api_key_here" \
  -d '{
    "jsonrpc": "2.0",
    "id": 2,
    "method": "tools/list",
    "params": {}
  }'
```

**Response:**
```json
{
  "jsonrpc": "2.0",
  "id": 2,
  "result": {
    "tools": [
      {
        "name": "echo",
        "description": "Echoes back the provided message",
        "inputSchema": {
          "type": "object",
          "properties": {
            "message": {
              "type": "string",
              "description": "The message to echo back"
            }
          },
          "required": ["message"]
        }
      }
    ]
  }
}
```

### 3. Call the Echo Tool

```bash
curl -X POST https://your.website.com/wp-json/websamurai/v1/mcp \
  -H "Content-Type: application/json" \
  -H "X-API-Key: sk_your_api_key_here" \
  -d '{
    "jsonrpc": "2.0",
    "id": 3,
    "method": "tools/call",
    "params": {
      "name": "echo",
      "arguments": {
        "message": "Hello, MCP Server!"
      }
    }
  }'
```

**Response:**
```json
{
  "jsonrpc": "2.0",
  "id": 3,
  "result": {
    "content": [
      {
        "type": "text",
        "text": "Hello, MCP Server!"
      }
    ]
  }
}
```

### 4. Get Server Info (Simple)

```bash
curl https://your.website.com/wp-json/websamurai/v1/mcp/info
```

**Response:**
```json
{
  "server": {
    "name": "websamurai-echo-server",
    "version": "1.0.0",
    "protocolVersion": "2024-11-05"
  },
  "endpoint": "https://your.website.com/wp-json/websamurai/v1/mcp",
  "tools": [
    {
      "name": "echo",
      "description": "Echoes back the provided message"
    }
  ]
}
```

## Configuration for Claude Desktop

Add this to your Claude Desktop MCP configuration with your API key:

```json
{
  "mcpServers": {
    "websamurai-echo": {
      "url": "https://your.website.com/wp-json/websamurai/v1/mcp",
      "transport": "http",
      "headers": {
        "X-API-Key": "sk_your_api_key_here"
      }
    }
  }
}
```

## Security Best Practices

1. **Keep API Keys Secret**: Never commit API keys to version control
2. **Use HTTPS**: Always use HTTPS in production to encrypt API keys in transit
3. **Rotate Keys**: Regularly generate new keys and delete old ones
4. **Unique Keys**: Use different API keys for different environments (dev, staging, production)
5. **Monitor Usage**: Check the "Last Used" column in the admin to detect unauthorized access

## Technical Details

- **Protocol**: JSON-RPC 2.0 over HTTP
- **Transport**: Stateless HTTP (no WebSocket or SSE)
- **Authentication**: API key-based authentication (X-API-Key or Authorization Bearer)
- **Key Format**: Keys are prefixed with `sk_` followed by 64 hexadecimal characters
- **Key Storage**: Keys are stored in WordPress options table with secure comparison
- **Error Handling**: Standard JSON-RPC error codes

## Implementation

The MCP server is implemented in `inc/mcp-server.php` and follows WordPress coding standards. It uses the WordPress REST API for routing and request handling.

### File Structure

```
websamurai/
├── websamurai.php           (Main plugin file)
├── inc/
│   ├── admin-page.php     (Admin page registration)
│   ├── api-keys.php       (API key management)
│   ├── enqueue.php        (Asset enqueuing)
│   └── mcp-server.php     (MCP server implementation)
├── src/
│   └── admin/
│       ├── components/
│       │   └── ApiKeyManager.jsx  (React component for key management)
│       ├── App.jsx        (Admin app entry)
│       ├── index.js       (React initialization)
│       └── styles.less    (Admin styles)
└── build/                 (Compiled assets - generated by webpack)
```

## Extending the Server

To add more tools, modify the `handle_tools_list()` and `handle_tools_call()` methods in the `WebSamurai_MCP_Server` class in `inc/mcp-server.php`.
